/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaunchGelBlock
extends Block {
    public static final VoxelShape SHAPE = LaunchGelBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public LaunchGelBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean canExistAt(LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isFaceSturdy((BlockGetter)world, pos, Direction.UP);
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        AutomobileEntity automobile;
        super.entityInside(state, world, pos, entity);
        if (entity instanceof AutomobileEntity && (automobile = (AutomobileEntity)entity).automobileOnGround()) {
            automobile.boost(0.14f, 7);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return this.canExistAt(world, pos);
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        super.neighborChanged(state, world, pos, block, fromPos, notify);
        if (!this.canExistAt((LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

